package gov.va.med.mhv.getcare.web.controller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import javax.annotation.Resource;
import javax.faces.bean.ManagedBean;
import javax.faces.bean.ViewScoped;
import javax.faces.event.ComponentSystemEvent;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.getcare.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.getcare.service.HealthCareProviderService;
import gov.va.med.mhv.getcare.web.compare.HealthCareProviderDTOByTypeCompare;
import gov.va.med.mhv.getcare.web.util.WebServiceClientUtil;

@ManagedBean
@Component
@ViewScoped
public class CareGiversController extends AbstractController {
	private static final long serialVersionUID = -6535420988397944819L;
	private static Logger log = LogManager.getLogger(CareGiversController.class);
	
	private List<HealthCareProviderDTO> providers = new ArrayList<HealthCareProviderDTO>();

	@Resource(name = "healthcareproviderServiceProxy")
	private HealthCareProviderService healthCareProviderService;

	public void init(ComponentSystemEvent event) {
		try {
			log.debug("init");
			findUser();
			userprofileId = getUserProfileIdFromSession();
			loadModel();
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

	}

	private void loadModel() {
		List<HealthCareProviderDTO> dtoList = null;
		try {
			Long userProfileId = getUserProfileIdFromSession();
			
			if (userProfileId == null) {
				providers.clear();
				return;
			}
			
			dtoList = healthCareProviderService.findDashBoardProvidersForUser(userProfileId);

			if (dtoList != null) {
				Collections.sort(dtoList, new HealthCareProviderDTOByTypeCompare());
				if (dtoList.size() > 5) {
					dtoList = dtoList.subList(0, 5);
				}
				providers = dtoList;
			} else {
				providers.clear();
			}
		} catch (MHVException e) {
			log.error(e);
			super.processErrorMessages(e);
		} catch (Exception e) {
			log.error(e);
			WebServiceClientUtil.showErrorMessage();
		}

	}

	public List<HealthCareProviderDTO> getProviders() {
		return providers;
	}

	public void setProviders(List<HealthCareProviderDTO> providers) {
		this.providers = providers;
	}

}
